#!/bin/bash

#################################################################
#	  __  __    _    _  _______    _    ____  ____  	#
#	 |  \/  |  / \  | |/ / ____|  / \  |  _ \|  _ \ 	#
#	 | |\/| | / _ \ | ' /|  _|   / _ \ | |_) | |_) |	#
#	 | |  | |/ ___ \| . \| |___ / ___ \|  __/|  __/ 	#
#	 |_|  |_/_/   \_\_|\_\_____/_/   \_\_|   |_|    	#
#                                                		#
#                	                                        #
#       @author MakeAPP.co.il    	                      	#
#       All copyright reserved. 2019               		#
#	                                                        #
#################################################################

VERSION="1.0";
LOG_FILE="/usr/local/files/error.log";
DATASTORE_DIR="/usr/local/files";
STEAMCMD_DIR="/usr/local/files/steamcmd";

if [ -d $STEAMCMD_DIR ]; then
	if [ "$1" == "" ] || [ "$2" == "" ] || [ "$3" == "" ]; then
		echo "Missing parameters.";
		echo "[ERROR]: Missing parameters." >> $LOG_FILE
	else
		cd $STEAMCMD_DIR && ./steamcmd.sh +login anonymous +force_install_dir $1 +app_update 740 validate +quit
		curl --data "serverid="$2"&path="$1 -A "mkBot" $3
		echo "[SUCCESS]: Server "$2" is successfully updated. ("$1")" >> $LOG_FILE
	fi
else
	echo "[ERROR]: Steam path invalid or not exists." >> $LOG_FILE
	echo "SteamCMD not exists or Path invalid.";
fi


