#!/bin/bash

#################################################################
#	  __  __    _    _  _______    _    ____  ____  	#
#	 |  \/  |  / \  | |/ / ____|  / \  |  _ \|  _ \ 	#
#	 | |\/| | / _ \ | ' /|  _|   / _ \ | |_) | |_) |	#
#	 | |  | |/ ___ \| . \| |___ / ___ \|  __/|  __/ 	#
#	 |_|  |_/_/   \_\_|\_\_____/_/   \_\_|   |_|    	#
#                                                		#
#                	                                        #
#       @author MakeAPP.co.il    	                      	#
#       All copyright reserved. 2019               		#
#	                                                        #
#################################################################

VERSION="1.0";
LOG_FILE="/usr/local/files/error.log";
STEAMCMD_DIR="/usr/local/files/steamcmd";
CSGO_FOLDER="/usr/local/files/csgo";

if [ -d $STEAMCMD_DIR ]; then
	if [ "$1" == "" ]; then
		echo "Missing parameters.";
		echo "[ERROR]: Missing parameters." >> $LOG_FILE
	else
		cd $STEAMCMD_DIR && ./steamcmd.sh +login anonymous +force_install_dir $CSGO_FOLDER +app_update 740 validate +quit
		curl -A "mkBot" $1
		echo "[SUCCESS]: CS:GO folder/path is successfully updated. ($CSGO_FOLDER)" >> $LOG_FILE
	fi
else
	echo "[ERROR]: Steam path invalid or not exists." >> $LOG_FILE
	echo "SteamCMD not exists or Path invalid.";
fi


